/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_793;
import net.minecraft.class_8177;
import net.minecraft.class_8567;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDoorBlock
extends class_2323
implements RenderLayerProvider,
BlockModelProvider,
TagProvider {
    protected BaseDoorBlock(class_2248 source, class_8177 type) {
        this(class_4970.class_2251.method_9630((class_4970)source).method_9629(3.0f, 3.0f).method_22488(), type);
    }

    protected BaseDoorBlock(class_4970.class_2251 properties, class_8177 type) {
        super(properties, type);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        if (state.method_11654((class_2769)field_10946) == class_2756.field_12607) {
            return Collections.singletonList(new class_1799((class_1935)this.method_8389()));
        }
        return Collections.emptyList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 resourceLocation, class_2680 blockState) {
        DoorType doorType = this.getDoorType(blockState);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_DOOR_BOTTOM, resourceLocation);
        switch (doorType) {
            case TOP_HINGE: {
                pattern = PatternsHelper.createJson(BasePatterns.BLOCK_DOOR_TOP_HINGE, resourceLocation);
                break;
            }
            case BOTTOM_HINGE: {
                pattern = PatternsHelper.createJson(BasePatterns.BLOCK_DOOR_BOTTOM_HINGE, resourceLocation);
                break;
            }
            case TOP: {
                pattern = PatternsHelper.createJson(BasePatterns.BLOCK_DOOR_TOP, resourceLocation);
                break;
            }
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)field_10938);
        DoorType doorType = this.getDoorType(blockState);
        boolean open = (Boolean)blockState.method_11654((class_2769)field_10945);
        boolean hinge = doorType.isHinge();
        class_1086 rotation = class_1086.field_5350;
        switch (facing) {
            case field_11034: {
                if (hinge && open) {
                    rotation = class_1086.field_5366;
                    break;
                }
                if (!open) break;
                rotation = class_1086.field_5347;
                break;
            }
            case field_11035: {
                if (!hinge && !open || hinge && !open) {
                    rotation = class_1086.field_5366;
                    break;
                }
                if (!hinge) break;
                rotation = class_1086.field_5355;
                break;
            }
            case field_11039: {
                if (!hinge && !open || hinge && !open) {
                    rotation = class_1086.field_5355;
                    break;
                }
                if (hinge) {
                    rotation = class_1086.field_5347;
                    break;
                }
                rotation = class_1086.field_5366;
                break;
            }
            default: {
                if (!hinge && !open || hinge && !open) {
                    rotation = class_1086.field_5347;
                    break;
                }
                if (hinge) break;
                rotation = class_1086.field_5355;
            }
        }
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + "_" + doorType);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createMultiVariant(modelId, rotation.method_3509(), false);
    }

    protected DoorType getDoorType(class_2680 blockState) {
        boolean isHinge = this.isHinge((class_2750)blockState.method_11654((class_2769)field_10941), (Boolean)blockState.method_11654((class_2769)field_10945));
        switch ((class_2756)blockState.method_11654((class_2769)field_10946)) {
            case field_12609: {
                return isHinge ? DoorType.TOP_HINGE : DoorType.TOP;
            }
            case field_12607: {
                return isHinge ? DoorType.BOTTOM_HINGE : DoorType.BOTTOM;
            }
        }
        return DoorType.BOTTOM;
    }

    private boolean isHinge(class_2750 hingeSide, boolean open) {
        boolean isHinge = hingeSide == class_2750.field_12586;
        return isHinge && !open || !isHinge && open;
    }

    @Override
    public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
        blockTags.add((class_6862<class_2248>)class_3481.field_15495);
        itemTags.add((class_6862<class_1792>)class_3489.field_15553);
    }

    public static BaseDoorBlock from(class_2248 source, class_8177 type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    protected static enum DoorType implements class_3542
    {
        BOTTOM_HINGE("bottom_hinge"),
        TOP_HINGE("top_hinge"),
        BOTTOM("bottom"),
        TOP("top");

        private final String name;

        private DoorType(String name) {
            this.name = name;
        }

        public boolean isHinge() {
            return this == BOTTOM_HINGE || this == TOP_HINGE;
        }

        public String toString() {
            return this.method_15434();
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class Stone
    extends BaseDoorBlock
    implements BehaviourStone {
        public Stone(class_2248 source, class_8177 type) {
            super(source, type);
        }

        public Stone(class_4970.class_2251 properties, class_8177 type) {
            super(properties, type);
        }
    }

    public static class Metal
    extends BaseDoorBlock
    implements BehaviourMetal {
        public Metal(class_2248 source, class_8177 type) {
            super(source, type);
        }

        public Metal(class_4970.class_2251 properties, class_8177 type) {
            super(properties, type);
        }
    }

    public static class Wood
    extends BaseDoorBlock
    implements BehaviourWood {
        public Wood(class_2248 source, class_8177 type) {
            super(source, type);
        }

        public Wood(class_4970.class_2251 properties, class_8177 type) {
            super(properties, type);
        }

        @Override
        public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((class_6862<class_2248>)class_3481.field_15494);
            itemTags.add((class_6862<class_1792>)class_3489.field_15552);
        }
    }
}

