/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_793;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRotatedPillarBlock
extends class_2465
implements BlockModelProvider,
DropSelfLootProvider<BaseRotatedPillarBlock> {
    protected BaseRotatedPillarBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected BaseRotatedPillarBlock(class_2248 block) {
        this(class_4970.class_2251.method_9630((class_4970)block));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        return this.getBlockModel(blockId, this.method_9564());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        Optional<String> pattern = this.createBlockPattern(blockId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createRotatedModel(modelId, (class_2350.class_2351)blockState.method_11654((class_2769)field_11459));
    }

    protected Optional<String> createBlockPattern(class_2960 blockId) {
        return PatternsHelper.createBlockPillar(blockId);
    }

    public static BaseRotatedPillarBlock from(class_2248 source, boolean flammable) {
        return BehaviourHelper.from(source, s -> new Wood((class_2248)s, flammable), Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseRotatedPillarBlock
    implements BehaviourWood {
        protected final boolean flammable;

        public Wood(class_4970.class_2251 settings, boolean flammable) {
            super(flammable ? settings.method_50013() : settings);
            this.flammable = flammable;
        }

        public Wood(class_2248 block, boolean flammable) {
            this(class_4970.class_2251.method_9630((class_4970)block), flammable);
        }
    }

    public static class Metal
    extends BaseRotatedPillarBlock
    implements BehaviourMetal {
        public Metal(class_4970.class_2251 settings) {
            super(settings);
        }

        public Metal(class_2248 block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseRotatedPillarBlock
    implements BehaviourStone {
        public Stone(class_4970.class_2251 settings) {
            super(settings);
        }

        public Stone(class_2248 block) {
            super(block);
        }
    }
}

