/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import org.betterx.bclib.config.ConfigUI;
import org.betterx.bclib.config.NamedPathConfig;

public class ClientConfig
extends NamedPathConfig {
    @ConfigUI(hide=true)
    public static final NamedPathConfig.ConfigToken<Boolean> DID_SHOW_WELCOME = NamedPathConfig.ConfigToken.Boolean(false, "didShowWelcome", "version");
    public static final NamedPathConfig.ConfigToken<Boolean> CHECK_VERSIONS = NamedPathConfig.ConfigToken.Boolean(true, "check", "version");
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.ConfigToken<Boolean> SHOW_UPDATE_INFO = NamedPathConfig.ConfigToken.Boolean(true, "showUpdateInfo", "ui");
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.ConfigToken<Boolean> PREFER_MODRINTH_FOR_UPDATES = NamedPathConfig.ConfigToken.Boolean(false, "useModrinthForUpdates", "ui");
    @ConfigUI(hide=true)
    public static final NamedPathConfig.ConfigToken<Boolean> FORCE_BETTERX_PRESET = NamedPathConfig.ConfigToken.Boolean(true, "forceBetterXPreset", "ui");
    @ConfigUI(topPadding=12)
    public static final NamedPathConfig.ConfigToken<Boolean> SUPPRESS_EXPERIMENTAL_DIALOG = NamedPathConfig.ConfigToken.Boolean(false, "suppressExperimentalDialogOnLoad", "ui");
    @ConfigUI(hide=true)
    public static final NamedPathConfig.ConfigToken<Boolean> NO_DONOR = NamedPathConfig.ConfigToken.Boolean(true, "notTheDonorType", "ui");
    @ConfigUI(topPadding=12)
    public static final NamedPathConfig.ConfigToken<Boolean> ENABLED = NamedPathConfig.ConfigToken.Boolean(true, "enabled", "auto_sync");
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.DependendConfigToken<Boolean> ACCEPT_CONFIGS = NamedPathConfig.DependendConfigToken.Boolean(true, "acceptConfigs", "auto_sync", config -> config.get(ENABLED));
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.DependendConfigToken<Boolean> ACCEPT_FILES = NamedPathConfig.DependendConfigToken.Boolean(true, "acceptFiles", "auto_sync", config -> config.get(ENABLED));
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.DependendConfigToken<Boolean> ACCEPT_MODS = NamedPathConfig.DependendConfigToken.Boolean(true, "acceptMods", "auto_sync", config -> config.get(ENABLED));
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.DependendConfigToken<Boolean> DISPLAY_MOD_INFO = NamedPathConfig.DependendConfigToken.Boolean(true, "displayModInfo", "auto_sync", config -> config.get(ENABLED));
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.ConfigToken<Boolean> DEBUG_HASHES = NamedPathConfig.ConfigToken.Boolean(false, "debugHashes", "auto_sync");
    @ConfigUI(topPadding=12)
    public static final NamedPathConfig.ConfigToken<Boolean> CUSTOM_FOG_RENDERING = NamedPathConfig.ConfigToken.Boolean(true, "customFogRendering", "rendering");
    @ConfigUI(leftPadding=8)
    public static final NamedPathConfig.ConfigToken<Boolean> NETHER_THICK_FOG = NamedPathConfig.DependendConfigToken.Boolean(true, "netherThickFog", "rendering", config -> config.get(CUSTOM_FOG_RENDERING));
    @ConfigUI(leftPadding=8, minValue=0, maxValue=2)
    public static final NamedPathConfig.ConfigToken<Float> FOG_DENSITY = NamedPathConfig.DependendConfigToken.Float(1.0f, "FogDensity", "rendering", config -> config.get(CUSTOM_FOG_RENDERING));
    @ConfigUI(topPadding=12)
    public static final NamedPathConfig.ConfigToken<Boolean> SURVIES_ON_HINT = NamedPathConfig.ConfigToken.Boolean(true, "survives_on_hint", "infos");

    public ClientConfig() {
        super("bclib", "client", false);
    }

    public boolean shouldPrintDebugHashes() {
        return this.get(DEBUG_HASHES);
    }

    public boolean isAllowingAutoSync() {
        return this.get(ENABLED);
    }

    public boolean isAcceptingMods() {
        return this.get(ACCEPT_MODS);
    }

    public boolean isAcceptingConfigs() {
        return this.get(ACCEPT_CONFIGS);
    }

    public boolean isAcceptingFiles() {
        return this.get(ACCEPT_FILES);
    }

    public boolean isShowingModInfo() {
        return this.get(DISPLAY_MOD_INFO);
    }

    public boolean suppressExperimentalDialog() {
        return this.get(SUPPRESS_EXPERIMENTAL_DIALOG);
    }

    public void setSuppressExperimentalDialog(boolean newValue) {
        this.set(SUPPRESS_EXPERIMENTAL_DIALOG, newValue);
    }

    public boolean netherThickFog() {
        return this.get(NETHER_THICK_FOG);
    }

    public boolean renderCustomFog() {
        return this.get(CUSTOM_FOG_RENDERING);
    }

    public boolean showUpdateInfo() {
        return this.get(SHOW_UPDATE_INFO);
    }

    public boolean isDonor() {
        return this.get(NO_DONOR) == false;
    }

    public float fogDensity() {
        return this.get(FOG_DENSITY).floatValue();
    }

    public boolean checkVersions() {
        return this.get(CHECK_VERSIONS);
    }

    public void setCheckVersions(boolean newValue) {
        this.set(CHECK_VERSIONS, newValue);
    }

    public boolean didShowWelcomeScreen() {
        return this.get(DID_SHOW_WELCOME);
    }

    public void setDidShowWelcomeScreen() {
        this.set(DID_SHOW_WELCOME, true);
    }

    public boolean forceBetterXPreset() {
        return this.get(FORCE_BETTERX_PRESET);
    }

    public void setForceBetterXPreset(boolean v) {
        this.set(FORCE_BETTERX_PRESET, v);
    }

    public boolean survivesOnHint() {
        return this.get(SURVIES_ON_HINT);
    }

    public boolean preferModrinthForUpdates() {
        return this.get(PREFER_MODRINTH_FOR_UPDATES);
    }
}

