/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.util.TreeMap;

public class RomanNumeral {
    private static final TreeMap<Integer, String> LITERALS = new TreeMap();

    private static void lazyInit() {
        if (LITERALS.isEmpty()) {
            LITERALS.put(1000, "M");
            LITERALS.put(900, "CM");
            LITERALS.put(500, "D");
            LITERALS.put(400, "CD");
            LITERALS.put(100, "C");
            LITERALS.put(90, "XC");
            LITERALS.put(50, "L");
            LITERALS.put(40, "XL");
            LITERALS.put(10, "X");
            LITERALS.put(9, "IX");
            LITERALS.put(5, "V");
            LITERALS.put(4, "IV");
            LITERALS.put(1, "I");
        }
    }

    public static String toRoman(int number) {
        RomanNumeral.lazyInit();
        return RomanNumeral._toRoman(number);
    }

    private static String _toRoman(int number) {
        if (number == 0) {
            return "0";
        }
        int l = LITERALS.floorKey(number);
        if (number == l) {
            return LITERALS.get(number);
        }
        return LITERALS.get(l) + RomanNumeral._toRoman(number - l);
    }
}

