/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.betterx.bclib.BCLib;

public class DatapackConfigs {
    private static DatapackConfigs INSTANCE = new DatapackConfigs();
    private Map<class_2960, DatapackConfigReloadHandler> handlers = new HashMap<class_2960, DatapackConfigReloadHandler>();

    public static DatapackConfigs instance() {
        return INSTANCE;
    }

    public void register(String modID, String fileName, DatapackConfigReloadHandler handler) {
        this.register(modID, fileName, () -> {}, handler);
    }

    public void register(final String modID, final String fileName, final DatapackConfigReloadPrepare prepare, final DatapackConfigReloadHandler handler) {
        final class_2960 handlerID = new class_2960(modID, "config_manager_" + fileName.replaceAll("/", "_").replaceAll(".", "_"));
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return handlerID;
            }

            public void method_14491(class_3300 manager) {
                prepare.onReload();
                DatapackConfigs.this.runForResources(manager, modID, fileName, handler);
            }
        });
    }

    public void runForResources(class_3300 manager, String modID, String fileName, DatapackConfigReloadHandler handler) {
        for (Map.Entry entry : manager.method_14488("config", id -> id.method_12836().equals(modID) && id.method_12832().endsWith(fileName)).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (obj == null) continue;
                    handler.onReload((class_2960)entry.getKey(), obj);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                BCLib.LOGGER.error("Error occurred while loading resource json " + entry.getKey(), e);
            }
        }
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadPrepare {
        public void onReload();
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadHandler {
        public void onReload(class_2960 var1, JsonObject var2);
    }
}

