/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.worldPreset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7145;
import net.minecraft.class_7225;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogetherWorldPreset
extends class_7145 {
    public final int sortOrder;
    private static int NEXT_IN_SORT_ORDER = 1000;
    private final class_7723 worldDimensions;
    @Nullable
    public final class_5321<class_7145> parentKey;
    private static DimensionsWrapper DEFAULT_DIMENSIONS_WRAPPER = null;

    public TogetherWorldPreset(Map<class_5321<class_5363>, class_5363> map, Optional<Integer> sortOrder) {
        this(map, sortOrder.orElse(NEXT_IN_SORT_ORDER++), null);
    }

    public TogetherWorldPreset(Map<class_5321<class_5363>, class_5363> map, Optional<Integer> sortOrder, @Nullable class_5321<class_7145> parentKey) {
        this(map, sortOrder.orElse(NEXT_IN_SORT_ORDER++), parentKey);
    }

    public TogetherWorldPreset(Map<class_5321<class_5363>, class_5363> map, int sortOrder) {
        this(map, sortOrder, null);
    }

    public TogetherWorldPreset(Map<class_5321<class_5363>, class_5363> map, int sortOrder, @Nullable class_5321<class_7145> parentKey) {
        super(map);
        this.sortOrder = sortOrder;
        this.worldDimensions = TogetherWorldPreset.buildWorldDimensions(map);
        this.parentKey = parentKey;
    }

    public static class_7723 buildWorldDimensions(Map<class_5321<class_5363>, class_5363> map) {
        class_2370 registry = new class_2370(class_7924.field_41224, Lifecycle.experimental());
        for (Map.Entry<class_5321<class_5363>, class_5363> entry : map.entrySet()) {
            class_2378.method_39197((class_2378)registry, entry.getKey(), (Object)entry.getValue());
        }
        return new class_7723((class_2378)registry);
    }

    public class_7723 getWorldDimensions() {
        return this.worldDimensions;
    }

    public TogetherWorldPreset withDimensions(class_2378<class_5363> dimensions, @Nullable class_5321<class_7145> parentKey) {
        HashMap<class_5321<class_5363>, class_5363> map = new HashMap<class_5321<class_5363>, class_5363>();
        for (Map.Entry entry : dimensions.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            map.put((class_5321<class_5363>)key, stem);
        }
        return new TogetherWorldPreset(map, this.sortOrder, parentKey);
    }

    private Map<class_5321<class_5363>, class_5363> getDimensions() {
        return ((WorldPresetAccessor)((Object)this)).bcl_getDimensions();
    }

    public Map<class_5321<class_5363>, class_2794> getDimensionsMap() {
        return DimensionsWrapper.build(this.getDimensions());
    }

    public class_5363 getDimension(class_5321<class_5363> key) {
        return this.getDimensions().get(key);
    }

    public static void writeWorldPresetSettings(class_7723 dimensions) {
        TogetherWorldPreset.writeWorldPresetSettings((class_2378<class_5363>)dimensions.comp_1014());
    }

    public static void writeWorldPresetSettings(class_2378<class_5363> dimensions) {
        DimensionsWrapper wrapper = new DimensionsWrapper(dimensions);
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    public static void writeWorldPresetSettings(Map<class_5321<class_5363>, class_5363> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(DimensionsWrapper.build(settings));
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    public static void writeWorldPresetSettingsDirect(Map<class_5321<class_5363>, class_2794> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(settings);
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    private static void writeWorldPresetSettings(DimensionsWrapper wrapper) {
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)WorldBootstrap.getLastRegistryAccessOrElseBuiltin());
        DataResult encodeResult = DimensionsWrapper.CODEC.encodeStart((DynamicOps)registryOps, (Object)wrapper);
        if (encodeResult.result().isPresent()) {
            class_2487 settingsNbt = WorldConfig.getRootTag("worlds_together");
            settingsNbt.method_10566("preset", (class_2520)encodeResult.result().get());
        } else {
            WorldsTogether.LOGGER.error("Unable to encode world generator settings for level.dat.");
        }
        WorldConfig.saveFile("worlds_together");
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> loadWorldDimensions() {
        try {
            class_2487 presetNBT;
            class_5455 registryAccess = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
            class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryAccess);
            if (DEFAULT_DIMENSIONS_WRAPPER == null) {
                DEFAULT_DIMENSIONS_WRAPPER = new DimensionsWrapper(TogetherWorldPreset.getDimensionsMap(WorldPresets.getDEFAULT()));
            }
            if (!(presetNBT = WorldGenUtil.getPresetsNbt()).method_10545("dimensions")) {
                return TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
            }
            Optional oLevelStem = DimensionsWrapper.CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)presetNBT)).resultOrPartial(WorldsTogether.LOGGER::error);
            return oLevelStem.orElse(TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER).dimensions;
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed to load Dimensions", e);
            return TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
        }
    }

    @Nullable
    public static class_2378<class_5363> getDimensions(class_5321<class_7145> key) {
        class_5455 access = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
        if (access == null) {
            WorldsTogether.LOGGER.error("No valid registry found!");
            return null;
        }
        Optional preset = access.method_30530(class_7924.field_41250).method_40264(key);
        if (preset.isEmpty()) {
            return null;
        }
        return ((class_7145)((class_6880.class_6883)preset.get()).comp_349()).method_45546().comp_1014();
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> getDimensionsMap(class_5321<class_7145> key) {
        class_2378<class_5363> reg = TogetherWorldPreset.getDimensions(key);
        if (reg == null) {
            return new HashMap<class_5321<class_5363>, class_2794>();
        }
        return DimensionsWrapper.build(reg);
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> getDimensionMap(class_7723 worldDims) {
        return DimensionsWrapper.build((class_2378<class_5363>)worldDims.comp_1014());
    }

    @NotNull
    public static class_7723 getWorldDimensions(class_5321<class_7145> key) {
        class_2378<class_5363> reg = TogetherWorldPreset.getDimensions(key);
        return new class_7723(reg);
    }

    private static class DimensionsWrapper {
        public static final Codec<DimensionsWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41224), (Codec)class_2794.field_24746).fieldOf("dimensions").orElse(new HashMap()).forGetter(o -> o.dimensions)).apply((Applicative)instance, DimensionsWrapper::new));
        final Map<class_5321<class_5363>, class_2794> dimensions;

        static Map<class_5321<class_5363>, class_2794> build(class_2378<class_5363> dimensions) {
            HashMap<class_5321<class_5363>, class_2794> map = new HashMap<class_5321<class_5363>, class_2794>();
            for (Map.Entry entry : dimensions.method_29722()) {
                class_5321 key = (class_5321)entry.getKey();
                class_5363 stem = (class_5363)entry.getValue();
                map.put((class_5321<class_5363>)key, stem.comp_1013());
            }
            return map;
        }

        static Map<class_5321<class_5363>, class_2794> build(Map<class_5321<class_5363>, class_5363> input) {
            HashMap<class_5321<class_5363>, class_2794> map = new HashMap<class_5321<class_5363>, class_2794>();
            for (Map.Entry<class_5321<class_5363>, class_5363> entry : input.entrySet()) {
                class_5321<class_5363> key = entry.getKey();
                class_5363 stem = entry.getValue();
                map.put(key, stem.comp_1013());
            }
            return map;
        }

        DimensionsWrapper(class_2378<class_5363> dimensions) {
            this(DimensionsWrapper.build(dimensions));
        }

        private DimensionsWrapper(Map<class_5321<class_5363>, class_2794> dimensions) {
            this.dimensions = dimensions;
        }
    }
}

