/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelQuadUtil {
    public static final int POSITION_INDEX = 0;
    public static final int COLOR_INDEX = 3;
    public static final int TEXTURE_INDEX = 4;
    public static final int LIGHT_INDEX = 6;
    public static final int NORMAL_INDEX = 7;
    public static final int VERTEX_SIZE = 8;

    public static int vertexOffset(int vertexIndex) {
        return vertexIndex * 8;
    }

    public static ModelQuadFacing findNormalFace(float x, float y, float z) {
        Vector3f normal = new Vector3f(x, y, z);
        if (!normal.isFinite()) {
            return ModelQuadFacing.UNASSIGNED;
        }
        float maxDot = 0.0f;
        class_2350 closestFace = null;
        for (class_2350 face : DirectionUtil.ALL_DIRECTIONS) {
            float dot = normal.dot((Vector3fc)face.method_23955());
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            closestFace = face;
        }
        if (closestFace != null && class_3532.method_15347((float)maxDot, (float)1.0f)) {
            return ModelQuadFacing.fromDirection(closestFace);
        }
        return ModelQuadFacing.UNASSIGNED;
    }

    public static ModelQuadFacing findNormalFace(int normal) {
        return ModelQuadUtil.findNormalFace(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal));
    }

    public static int calculateNormal(ModelQuadView quad) {
        float normZ;
        float dx0;
        float dx1;
        float normY;
        float dy1;
        float dz0;
        float x0 = quad.getX(0);
        float y0 = quad.getY(0);
        float z0 = quad.getZ(0);
        float x1 = quad.getX(1);
        float y1 = quad.getY(1);
        float z1 = quad.getZ(1);
        float x2 = quad.getX(2);
        float y2 = quad.getY(2);
        float z2 = quad.getZ(2);
        float x3 = quad.getX(3);
        float y3 = quad.getY(3);
        float dy0 = y2 - y0;
        float z3 = quad.getZ(3);
        float dz1 = z3 - z1;
        float normX = dy0 * dz1 - (dz0 = z2 - z0) * (dy1 = y3 - y1);
        float l = (float)Math.sqrt(normX * normX + (normY = dz0 * (dx1 = x3 - x1) - (dx0 = x2 - x0) * dz1) * normY + (normZ = dx0 * dy1 - dy0 * dx1) * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        return NormI8.pack(normX, normY, normZ);
    }
}

